#!/bin/bash
# slony_propagate.sh
# Auteur : Stphane Schildknecht
# 2009-05-11

# Script de propagation de requtes SQL  l'ensemble des noeuds sans
# passer par Slony
## EN: Propagation of an SQL script, outside slony


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/
#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
    if [[ x"$LANG" = xfr* ]]; then
      echo "$0"
      echo ""
      echo "Usage : $0 *options*"
      echo -e "        Propagation d'un script SQL"
      echo "  Options :"
      echo "   --help                Afficher ce message"
      echo "   -c|--cluster          Le nom de l'instance de rplication"
      echo "   -f|--file             Le fichier contenant le script SQL"
      echo ""
else
      echo "$0"
      echo ""
      echo "Usage: $0 *options*"
      echo -e "        Propagation of an SQL script outside slony"
      echo "  Options :"
      echo "   --help                Print this message"
      echo "   -c|--cluster          The replication instance name"
      echo "   -f|--file             The SQL script file"
      echo ""
fi 
}

TEMP=`getopt -n $0 -o c:f: -l help,cluster:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
       -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *) echo "Warning!" ;
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

CLUSTERNAME=$INSTANCE

# Constitution d'un tableau  deux dimensions.
node $INSTANCE

# Suppression des bases de donnes sur les esclaves
for (( i=0 ; i < taille_nod ; i+=4 )); do
    echo "#"
    echo "Base ${NODE[$i+2]} - Node ${NODE[$i+1]}"
	
    $PG/bin/psql -U ${SLONY_USER} ${NODE[$i+2]} -h ${NODE[$i+3]} -p ${NODE[$i+4]} -f $FILE
    if [ $? -ne 0 ]; then
	exit_on_error "Propagation";
        exit 1;
    fi
    echo "##"
	
done

exit 0
