#!/bin/bash
# Auteur : Stephane Schildknecht
# 2007-01-15
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# slony_repstat.sh
# Script de vérification de la synchronisation d'un esclave


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
    echo "$0"
    echo ""
    echo "Usage : $0 *options*"
    echo "  Options :"
    echo "   --help                Afficher ce message"
    echo "   -c|--cluster          Le nom de l'instance de réplication"
    echo ""
else
    echo "$0"
    echo ""
    echo "Usage: $0 *options*"
    echo "  Options:"
    echo "   --help                Print this help"
    echo "   -c|--cluster          The replication instance name"
    echo ""
fi
}

TEMP=`getopt -n $0 -o c: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
	    NODE1=$1
	    NODE2=$2
                break
                ;;
        *) 
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi


# Récupération des informations sur les noeuds de la réplication
## EN: Nodes and relations arrays
relbase_miss
if [ $? -eq 1 ]; then
    exit 1
fi

if [[ -n $NODE1 && -n $NODE2 ]]; then
    if [ -e ${SLON_ETC}/bases.h ]; then
    
            while read line
            do
		echo $line | grep -v "^#" | grep "^$INSTANCE\b" > /dev/null
		if [ $? -eq 0 ] ; then
		    BASE=( $line )
                    if [ ${BASE[1]} -eq $NODE1 ]; then
			MASTERNODE=${BASE[1]} #Numéro du noeud
                        MASTERBASE=${BASE[2]} #Base
                        MASTERHOST=${BASE[3]} #Host
                        MASTERPORT=${BASE[4]} #Port
		    elif [ ${BASE[1]} -eq $NODE2 ]; then
                        SLAVENODE=${BASE[1]} #Numéro du noeud
                        SLAVEBASE=${BASE[2]} #Base
                        SLAVEHOST=${BASE[3]} #Host
                        SLAVEPORT=${BASE[4]} #Port
		    fi		
                fi
            done < $SLON_ETC/bases.h
    
    else
    
       echo "Fichier de définition des réplications (${SLON_ETC}/bases.h) introuvable."
       echo "Vérifiez votre installation."
    
       exit 1
    
    fi
    
    echo " "
    if [[ x$LANG = xfr* ]]; then
	echo "$INSTANCE : décalage entre le maître et l'esclave"
    else
	echo "$INSTANCE: Lag between slave and master"
    fi
    $PG/bin/psql $MASTERBASE -U ${SLONY_USER} -h $MASTERHOST -p $MASTERPORT -t -c "select st_lag_num_events||' SYNC et '||st_lag_time from \"_$INSTANCE\".sl_status where st_received=$NODE2;"
    if [[ x$LANG = xfr* ]]; then
	echo "Avec un décalage <=1, il est possible d'effectuer une bascule de la réplication."
    else
	echo "If lag <= 1, you can switchover."
    fi

else
    node $INSTANCE
    for SETID in `grep "\b$INSTANCE\b" $SLON_ETC/relations.h | grep -v "^#" | awk '{print \$2}' | sort -u`; do
	relation $SETID
	echo "SET $SETID :"
	MASTERNODE=${NODE[${INDEX[$MASTER]}]}   #Numéro du noeud
	MASTERBASE=${NODE[${INDEX[$MASTER]}+1]} #Base
	MASTERHOST=${NODE[${INDEX[$MASTER]}+2]} #Host
	MASTERPORT=${NODE[${INDEX[$MASTER]}+3]} #Port
	$PG/bin/psql $MASTERBASE -U ${SLONY_USER} -h $MASTERHOST -p $MASTERPORT -t -c "select 'Noeud '||st_received||' : '||st_lag_num_events||' SYNC et '||st_lag_time from \"_$INSTANCE\".sl_status order by st_received;"
    done
fi
exit 0


