#!/bin/bash
# Auteur : Stephane Schildknecht
# 2007-05-22
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables

# slony_subscribe.sh
# Script de resouscription des noeuds, en fonction du fichier relations.h
## EN: Resubscribe nodes regarding relations.h

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo -e "        Permet de resouscrire le set conformément au fichier relations.h"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    else	
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo -e "        Re-subscribing set regarding relations.h"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The replication instance name"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
                slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

# Il est impératif que les fichiers ${SLON_ETC}/bases.h et 
# ${SLON_ETC}/$CLUSTERNAME.preamble soient à jour.
## EN: Are needed files available?
relbase_miss
if [ $? -ne 0 ]; then
    exit 1
fi

# Création des tableaux
## EN: nodes array
node $INSTANCE

SUPER=0
GREP_SET="grep \"\b$INSTANCE\b\" $SLON_ETC/relations.h | grep -v \"^#\" | awk '{print \$2}' | sort -u"
for SETID in `eval $GREP_SET` ; do
    ## EN: relations array
    relation $SETID

# Pour toutes les relations, on souscrit SLAVE à MASTER
# Il est préférable d'attendre que SLAVE ait déjà souscrit, s'il doit être esclave-maître
# Double boucle pour les souscriptions
## EN: For every relation, SLAVE subscribes to MASTER
# In case SLAVE has to be provider, we wait for complete subscription.
# Double loop
    for (( i=1 ; i <= taille_rel ; i+=2 )); do
	mtr1=${REL[$i]}     #MAITRE
	slv1=${REL[$i+1]}  #ESCLAVE
	for (( j=1 ; j <= taille_rel ; j+=2 )); do
	    # Si mtr est slv d'un autre noeud
	    ## If mtr is already a slave
	    if [ ${REL[$j+1]} -eq ${REL[$i]} ]; then
		mtr=${INDEX[${REL[$j]}]}
		slv=${INDEX[${REL[$j+1]}]}
		while [ 1 ] ; do
		    if [[ x$LANG = xfr* ]]; then
			echo -n "Attente souscription ${REL[$j]} par ${REL[$j+1]}"
		    else
			echo -n "Wating ${REL[$j+1]} has subscribed to {REL[$j]}"
		    fi
		    if [ x`$PG/bin/psql -t ${NODE[$mtr+1]} -U ${SLONY_USER} -h ${NODE[$mtr+2]} -p ${NODE[$mtr+3]} -c "select sub_active from _$INSTANCE.sl_subscribe where sub_receiver=${NODE[$slv]} and sub_set=$SETID" |awk '{print \$1}' |head -n 1` = "xt" ]; then
    			echo "OK"
    		    	break;
		    else
			echo -n "."
    			sleep 5
		    fi
		done
            fi
	done
	# On peut souscrire
	# OK, let's subscribe

	$SLON_BIN/slonik <<_EOF_
	# ----
	# Preamble file
	# ----
	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
	
	# ----
	# Node $slv1 subscribes set $SETID
	# ----
	try{
		echo '$slv1 subscribes set $SETID on $mtr1: ';
		subscribe set ( id = $SETID, provider = $mtr1, receiver = $slv1, forward = yes);
	}
	on error {
	    echo 'ko';
	    exit 1;
	}
	on success {echo 'OK';}
_EOF_

    done
done
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
    else
	echo "An error occured."
    fi
    exit 1
fi
exit 0
