#!/bin/bash
# Auteur : Stephane Schildknecht
# 2007-01-15
# REV 2007-05-14 : Prise en compte de la nouvelle architecture
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20080401 SAS
#    Le subscribe est effectué avant le move set
#    Cela permet de supprimer les souscripteurs directs d'un noeud a supprimer
#

# slony_switch.sh
## FR : Script de bascule contrôlée entre deux noeuds
## EN: Switchover script between 2 nodes


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo -e "        Bascule contrôlée d'une réplication"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo "   -f|--failed           Le numéro de l'ancien maître"
	echo "   -b|--backup           Le numéro du nouveau maître"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo -e "        Switchover"
	echo "  Options :"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The replication instance name"
	echo "   -f|--failed           The failed node (ancient provider)"
	echo "   -b|--backup           The backup node (new provider)"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c:f:b: -l help,cluster:,failed:,backup -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
FAILED=""
BACKUP=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ;
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -f|--failed) shift ;
                FAILED="$1"
                ;;
        -b|--backup) shift ;
                BACKUP="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$FAILED" = "x" -o x"$BACKUP" = "x" ]; then
    slhelp;
    exit 1
fi

MASTERNODE=$FAILED
SLAVENODE=$BACKUP

## FR : Afin d'automatiser la bascule, il est nécessaire de récupérer
# les informations concernant le maitre et l'esclave.
# Dans ce cas, le fichier de préambule doit être à jour.
# Si ce n'était pas le cas, peut-être faut-il le recréer.
# Cela n'est pas fait dans ce script.

# Il est impératif que les fichiers ${SLON_ETC}/bases.h et 
# ${SLON_ETC}/$CLUSTERNAME.preamble soient à jour.

## EN: To automate the switch, we need acurate information on nodes 
# (master-slave). Preamble file has to be up to date. We can't test that here.
# Its re-creation should be thought about out of that script.
# Same for ${SLON_ETC}/bases.h and ${SLON_ETC}/relations.h. We test if they exist.


if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h -o ! -e ${SLON_ETC}/$INSTANCE.preamble]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Fichier ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h ou ${SLON_ETC}/$INSTANCE.preamble introuvable."
	echo "Merci de vérifier votre installation."
    else
	echo "Can't find ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h or ${SLON_ETC}/$INSTANCE.preamble"
	echo "Please verify your settings."
    fi
    exit 1
fi

## FR : Création des tableaux
## EN: Creation of arrays
node $INSTANCE

MASTERDB=${NODE[${INDEX[$MASTERNODE]}+1]}
MASTERHOST=${NODE[${INDEX[$MASTERNODE]}+2]}
MASTERPORT=${NODE[${INDEX[$MASTERNODE]}+3]}

## FR : Mise à jour du fichier de relations
## EN: We try to recreate relations file
relation_file $INSTANCE $MASTERDB $MASTERHOST $MASTERPORT

SUPER=0
GREP_SET="grep \"\b$INSTANCE\b\" $SLON_ETC/relations.h | grep -v \"^#\" | awk '{print \$2}' | sort -u"

for SETID in `eval $GREP_SET` ; do
	relation $SETID
	echo "set : $SETID, MASTER=$MASTER"

	if [ $MASTERNODE -eq $MASTER ]; then
## FR : Pour tous les autres souscripteurs, on resouscrit au nouveau maître de réplication
## EN: Every other subscriber is subscribed to new provider
            for (( j=1 ; j <= taille_rel ; j+=2 )); do
                if [ ${REL[$j]} -eq $MASTERNODE ]; then
                    OLDSLAVE=${REL[$j+1]}
                    let mtr=${INDEX[${REL[$j]}]}
                    let slv=${INDEX[${REL[$j+1]}]}
                    if [ $OLDSLAVE -ne $SLAVENODE ]; then
                        echo MASTER : $SLAVENODE \| NODE : $OLDSLAVE
                        ${SLON_BIN}/slonik <<_EOF_
                        #--
                        # <preamble> file inclusion
                        #--
                        INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
    
                        try{
                            echo '$OLDSLAVE subscribes SET $SETID on $SLAVENODE: ';
                            SUBSCRIBE SET (
                                ID = $SETID,
                                PROVIDER = $SLAVENODE,
                                RECEIVER = $OLDSLAVE,
                                FORWARD = YES );
                        }
                        on success { echo 'OK' ;}
                        on error { echo 'KO' ;}
_EOF_
		    fi
		fi
	    done

## FR : On switche le maître
## EN: master switch
		${SLON_BIN}/slonik <<_EOF_
	    #--
	    # <preamble> file inclusion
	    #--
	    INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
	    
		try{
		    echo 'unlock $SETID : ';
		    UNLOCK SET (
	            ID = $SETID,
	            ORIGIN = $MASTERNODE );
	    }
		on success { echo 'OK' ;}
		on error { echo 'KO' ;}
		
		try{
		    echo 'move set $SETID : ';
		    LOCK SET ( 
				ID = $SETID,
		    	ORIGIN = $MASTERNODE ) ;
		    echo 'lock set : OK';
		    echo 'move set : ';
	   	    MOVE SET ( 
		    	ID = $SETID,
		    	OLD ORIGIN = $MASTERNODE,
		    	NEW ORIGIN = $SLAVENODE );
		}
		on error { echo 'KO' ;}
	    on success { echo 'OK' ;}
_EOF_

	else
	## FR : Pour tous les esclaves
	# Peut-on vérifier qu'un noeud ne souscrit pas à un set donné ?
	## EN: For every slave (How should we verify a node does not subscribe
	# to a given set?
		for (( j=1 ; j <= taille_rel ; j+=2 )); do
		    if [ ${REL[$j]} -eq $MASTERNODE ]; then
	            OLDSLAVE=${REL[$j+1]}
			if [ $OLDSLAVE -ne $SLAVENODE ]; then
			    ${SLON_BIN}/slonik <<_EOF_
			    #--
			    # <preamble> file inclusion
			    #--
			    INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
		
			    ## FR : On rattache l'esclave au père du noeud à switcher
			    ## EN: Slave subscribes to provider of switched node
			    try{
				echo '$OLDSLAVE subscribes $SETID on $MASTER: ';
			        SUBSCRIBE SET (
						ID = $SETID,
						PROVIDER = $MASTER,
						RECEIVER = $OLDSLAVE,
						FORWARD = YES );
			    }
			    on success { echo 'OK' ;}
			    on error { echo 'KO' ;}
			    ## FR : On rattache le noeud à son ancien esclave
			    ## EN: Node subscribes ancient slave
			    try{
				echo 'Souscription set $SETID par $MASTERNODE : ';
				SUBSCRIBE SET (
						ID = $SETID,
				                PROVIDER = $OLDSLAVE,
						RECEIVER = $MASTERNODE,
						FORWARD = YES );
	            }
	            on success { echo 'OK' ;}
	            on error { echo 'KO' ;}
_EOF_
				fi
    		fi
		done
	fi
done

MASTERDB=${NODE[${INDEX[$SLAVENODE]}+1]}
MASTERHOST=${NODE[${INDEX[$SLAVENODE]}+2]}
MASTERPORT=${NODE[${INDEX[$SLAVENODE]}+3]}

## FR : Il est nécessaire d'attendre un peu...
## EN: How could sleep long enough, but not too much?
sleep 30s

## FR : Mise à jour du fichier de relations
## EN: Updating relations.h file
relation_file $INSTANCE $MASTERDB $MASTERHOST $MASTERPORT

## FR : Il est nécessaire de trier le ficher de relations...
# Dans l'immédiat, ce tri doit être fait à la main.
## EN: Relation file should be sorted. Today sort has to be done manually.

exit 0
