#!/bin/bash
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh


slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
  	echo ""
  	echo "Usage : $0 *options*"
  	echo "  Options :"
  	echo "   --help                Afficher ce message"
  	echo "   -c|--cluster          Le nom de l'instance de réplication"
  	echo "   -s|--set              Le numéro du set"
  	echo "   -p|--pere             Le maître"
  	echo "   -f|--fils             L'esclave"
  	echo ""
    else
	echo "$0"
  	echo ""
  	echo "Usage: $0 *options*"
  	echo "  Options:"
  	echo "   --help                Print this help"
  	echo "   -c|--cluster          The replication instance name"
  	echo "   -s|--set              The set number"
  	echo "   -p|--pere             Father"
  	echo "   -f|--fils             Son"
  	echo ""
    fi
}

TEMP=`getopt -n $0 -o c:s:p:f:h -l help,set:,cluster:,fils:,pere: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
PERE=""
FILS=""

while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        -p|--pere) shift ;
                PERE="$1"
                ;;
        -f|--fils) shift ;
                FILS="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$PERE" = "x" -o x"$FILS" = "x" ]; then
    slhelp;
    exit 1
fi

relation $SET
    
trouve=0
#echo -n $PERE---
for (( i=1 ; i <= taille_rel ; i+=2 )); do
    if [ ${REL[$i]} -eq $FILS ]; then
	if [ $trouve -gt 0 ]; then
	    echo -n "   \--"
	else
	    echo -n "$FILS--"
	fi
	let trouve=$trouve+1
        ${SLON_OUTILS}/tree.sh -c $INSTANCE -s $SET -p $FILS -f ${REL[$i+1]} 
    fi
done
if [ $trouve -eq 0 ]; then
    echo $FILS
fi
exit 0
