#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-12-18
# Rev 2007-04-17
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# upgrade_slon.sh
# Script de montee de version de Slony1
# Nécessite une mise jour des schémas
## EN: Upgrading slony

# TODO : Modification du script pour utilisation avec
#        toute base de tout serveur

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
    if [[ x$LANG = xfr* ]]; then
        echo "$0"
        echo ""
        echo "Usage : $0 *options*"
        echo "  Mise à jour des procédures internes Slony"
        echo "  Options :"
        echo "   --help                Afficher ce message"
        echo "   -c|--cluster          Le nom de l'instance de réplication"
        echo ""
    else
        echo "$0"
        echo ""
        echo "Usage: $0 *options*"
        echo "  Upgrading Slony"
        echo "  Options:"
        echo "   --help                Print this help"
        echo "   -c|--cluster          The replication instance name"
        echo ""
    fi
}

TEMP=`getopt -n $0 -o c:h -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ;
                slhelp;
                exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
                echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

cat <<EOF

#Arret de slon
## EN: First, we stop running daemons
${SLON_OUTILS}/slony_ctl.sh -c ${INSTANCE} stop

${SLON_BIN}/slonik <<_EOF_
        #--
        # <preamble> file
        #--
	include <$SLON_ETC/$INSTANCE.preamble>

    	#--
    	# Mise à jours des schémas
   	## Call slonik procedure to upgrade 
    	#--
	try{
	   echo 'Upgrade Slony:';
EOF
for NODE in `grep "\b$INSTANCE\b" $SLON_ETC/bases.h | grep -v "^#" | awk '{print $2}'`;do
cat <<EOF
	   echo 'Node $NODE:';
    	   update functions ( id=$NODE );
EOF
done

cat << EOF
	}
	on error {
	    echo 'ko' ;
	    exit 1;
	    }
        on success { echo 'OK' ; }
     
	exit 0;
_EOF_

if [ \$? -ne 0 ]; then
    if [[ x\$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
    else
	echo "An error occured."
    fi
    exit 1
fi

#Demarrage de la replication
${SLON_OUTILS}/slony_ctl.sh -c ${INSTANCE} start

EOF

exit 0

