---
myst:
  html_meta:
    keywords: LaTeX, schémas, schéma, schema, circuits, circuit, électriques, tikZ, tikz, électronique
---
# Comment tracer des circuits électriques avec <ctanpkg:circuitikz> ?


:::{note}
Bien que cela ne soit pas indispensable, une connaissance basique du package
<ctanpkg:tikz> est un plus.
:::

Le package <ctanpkg:circuitikz> fournit un environnement `circuitikz` dans lequel on décrit le circuit à
construire.

## Chargement du package et symboles européens

```{noedit}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
```

- `RPvoltages` (Rising Potential voltages) : les flèches de tensions suivent par défaut le
  sens conventionnel (pour les récepteurs et les générateurs) ;
- `straightvoltages` : flèche des tensions droites (courbées par défaut) ;
- `european voltage` et `european current` : sources de tension et d’intensité idéale au
  format européen.

## Circuit sans dipôles

Pour construire un circuit, pour l’instant sans dipôles, on utilise le code suivant :

```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}

\begin{circuitikz}
	\draw (0,0) to (4,0) to (4,-4) to (0,-4) to (0,0);
\end{circuitikz}

\end{document}
```

On comprend qu’il s’agit d’indiquer des coordonnées des points.

```{attention}
Bien penser à terminer chaque instruction par `;`.
```


## Ajout des dipôles
Pour ajouter des dipôles, on indique un paramètre optionnel après la liaison
`to` :

```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}

\begin{circuitikz}
	\draw (0,0) to [vsource] (4,0) to [lamp] (4,-4) to [R] (0,-4) to [empty led] (0,0);
\end{circuitikz}

\end{document}
```

Pour les autres dipôles, voir  [la liste des dipôles usuels](#dipoles-usuels).

## Intensité et tension

Reprenons le circuit précédent pour y ajouter les tensions  et l’intensité :

```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}
\begin{circuitikz}
	\draw (0,0) to [vsource, v=$u_G$, i=$i$] (4,0)
	to [lamp, v=$u_L$] (4,-4)
	to [R, v=$u_R$] (0,-4)
    to [empty led, v=$u_D$] (0,0);
\end{circuitikz}
\end{document}
```

## Ajout d'une dérivation

Pour ajouter une boucle supplémentaire, on ajoute une nouvelle instruction `\draw` qui
doit également se terminer par `;`.

```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}
\begin{circuitikz}
	% première boucle
	\draw (0,0) to [vsource, v=$u_G$, i=$i$] (4,0)
    to [lamp, v=$u_L$, i=$i_2$] (4,-4)
    to [R, v=$u_R$] (0,-4)
    to [empty led, v=$u_D$] (0,0);
    % deuxième boucle
    \draw (4,0) to (6,0)
    to [lamp, i=$i_1$] (6,-4)
    to (4,-4);
\end{circuitikz}
\end{document}
```

## Réglages manuels
Pour régler manuellement le sens des flèches, ou pour modifier leur position, on utilise
les caractères `<`, `>`, `_` et `^`.


```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}
\begin{circuitikz}
    \draw (0,0) to [vsource, v=$u_G$, i=$i$] (4,0)
    to [lamp, v=$u_L$, i^>=$i_2$, *-*] (4,-4)
    to [R, v=$u_R$] (0,-4)
    to [empty led, v=$u_D$] (0,0);
    %
    \draw (4,0) to (6,0)
    to [lamp, i>^=$i_1$] (6,-4)
    to (4,-4);
\end{circuitikz}
\end{document}
```

:::{note}
L’ordre dans lequel on indique la position du nom et le sens du courant a une
influence. On peut constater la différence en comparant les positions de $i_1$ et $i_2$ dans le
code précédent.
:::

## Quelques exemples de dipôles

:::{table} Dipôles de bases
:widths: auto
:name: dipoles-usuels
:align: left

| Dipôles                        | Argument optionnel à passer à `to` |
|--------------------------------|------------------------------------|
| Résistance                     | `R`                                |
| Résistance variable            | `vR`                               |
| Photorésistance                | `phR`                              |
| Thermistance                   | `thR`                              |
| Diode                          | `empty diode`                      |
| Led                            | `empdy led`                        |
| Photodiode                     | `empty photodiode`                 |
| Pile                           | `battery2`                         |
| Source de tension              | `vsource`                          |
| Source de tension sinusoïdale  | `sV`                               |
| Ampèremètre                    | `rmeter, t=A`                      |
| Voltmètre                      | `rmeter, t=V`                      |
| Lampe                          | `lamp`                             |
| Interrupteur                   | `normal open switch`               |
| Interrupteur qu’on ouvre       | `opening switch`                   |
| Interrupteur qu’on ferme       | `closing swich`                    |
| Condensateur                   | `C`                                |
| Bobine                         | `L`                                |
| Fil vide (pour ajouter u ou i) | `short`                            |
| Oscilloscope                   | `oscope`                           |
:::

:::{note}
Pour la Terre on définit un node (au sens de Ti*k*Z) auquel on passe l’option `eground`.
:::

Ci-dessous, un dernier exemple.

```
\documentclass{article}
\usepackage[
  european resistor,
  RPvoltages,
  european current,
  european voltage,
  straightvoltages
  ]{circuitikz}
\usetikzlibrary{babel}
\begin{document}
\begin{circuitikz}
   \draw (0,0)
    to [sV] (0,3)
    to[lamp] (3,3)
    to [R, *-*] (3,0)
    -- (0,0);
    \draw (3,3) -- (5,3) to [oscope, l=Ocsillo] (5,0) -- (3,0);
    \draw (0,0) to[short, *-] (0,-.5) node[eground]{};
\end{circuitikz}
\end{document}
```


```{sources}
https://nboulaire.developpez.com/tutoriels/latex/circuitikz_base/#LI-A
```

