---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, messages d'erreurs, format DVI, polices, Metafont
---

# Où se trouvent les polices *Almost Computer Modern* (AM) ?

On rencontre *encore* occasionnellement une demande pour la série de polices
*Almost Computer Modern* (autrement "presque *Computer Modern*). 
Ces dernières doivent leur nom du fait qu'elles précédaient les polices *Computer Modern*
(plus précisément, elles ont acquis leur nom "presque" après avoir réalisé 
que leur première implémentation dans MetaFont79 n'était toujours pas tout à fait correcte.
L'intention initiale de Knuth était qu'elles soient la version finale).

Il n’y a pas grand chose à faire avec ces polices : elles sont (comme leur nom l'indique) 
presque (mais pas tout à fait) les mêmes que la série *Computer Modern*).
Si vous êtes confronté à un document qui les demande, la seule approche raisonnable 
est de modifier le document pour remplacer les noms de police `am**` par `cm**`.

L'apparition de fichiers DVI qui en font la demande est suffisamment rare 
pour que personne n'ait entrepris la tâche gigantesque de créer une traduction 
de ceux-ci au moyen de polices virtuelles.

Vous devez donc tromper le système en lui faisant utiliser des polices `cm*` 
là où l'auteur original a spécifié `am*`.

Une option concerne les substitutions de polices que de nombreux pilotes DVI fournissent 
via leur fichier de configuration : spécifiez que chaque police *Almost Computer Modern* 
doit être remplacée par sa police *Computer Modern* correspondante.

Alternativement, on peut essayer l'édition DVI : les extensions <ctanpkg:dtl> 
(DVI Text Language) et <ctanpkg:dviasm> (assembleur DVI) peuvent tous deux 
fournir des méthodes d'allers-retours entre texte et DVI. 
La méthode demande alors d'éditer les noms de polices 
(dans toute la représentation textuelle du fichier) au milieu de ces allers-retours.

Le texte DTL est assez simple pour faire cela : les noms de polices sont entre guillemets simples
à la fin des lignes. Ainsi vous lancez l'instruction suivante en ligne de commande

```bash
dv2dt -o ⟨doc.txt⟩ ⟨doc.dvi⟩
```

Vous éditez ensuite le fichier texte puis vous exécutez une nouvelle instruction 
(ce qui pourra vous demander de compiler les programmes en C pour cela) :

```bash
dt2dv -o ⟨docrevu.dvi⟩ ⟨docrevu.txt⟩
```

Le script python `dviasm`, présente dans son fichier en sortie des noms de polices 
dans une section proche du début du document, puis répartis dans tout le corps. 
Le principe de modification sera très similaire à ce qui a été vu avant. 
Vous exécutez l'instruction suivante :


```bash
python dviasm.py -o ⟨doc.txt⟩ ⟨doc.dvi⟩
```

Puis vous éditez le fichier texte obtenu et exécutez enfin une autre instruction : 

```bash
python dviasm.py -o ⟨docrevu.dvi⟩ ⟨docrevu.txt⟩
```

Les deux voies semblent acceptables. Chaque utilisateur peut choisir la sienne 
(mais il est peu probable que cela soit nécessaire très souvent...).


:::{sources}
[Where are the am fonts?](faquk:FAQ-amfonts)
:::